// ChangeSetupDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Na vrcholu script changer.h"
#include "ChangeSetupDlg.h"
#include "Na vrcholu script changerdlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChangeSetupDlg dialog


CChangeSetupDlg::CChangeSetupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CChangeSetupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CChangeSetupDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CChangeSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CChangeSetupDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CChangeSetupDlg, CDialog)
	//{{AFX_MSG_MAP(CChangeSetupDlg)
	ON_BN_CLICKED(IDC_GENERATE_CODE, OnGenerateCode)
	ON_EN_CHANGE(IDC_FROM, OnChangeFrom)
	ON_EN_CHANGE(IDC_TO, OnChangeTo)
	ON_EN_CHANGE(IDC_REPLACE_BY, OnChangeReplaceBy)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChangeSetupDlg message handlers

BOOL CChangeSetupDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
    InitControls();
    
    return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CChangeSetupDlg::InitControls()
{
SetDlgItemText (IDC_FROM, AfxGetApp()->GetProfileString(_T("Change setup"), _T("From"), _T("<!-- NAVRCHOLU.cz -->")));
SetDlgItemText (IDC_TO, AfxGetApp()->GetProfileString(_T("Change setup"), _T("To"), _T("<!-- NAVRCHOLU.cz - konec -->")));
SetDlgItemText (IDC_ID, AfxGetApp()->GetProfileString(_T("Change setup"), _T("Id"), _T("00000000")));
OnGenerateCode();
OnChangeFrom();
OnChangeTo();
OnChangeReplaceBy();
}

void CChangeSetupDlg::OnGenerateCode() 
{
BOOL Trans;
DWORD Code = GetDlgItemInt(IDC_ID, &Trans, FALSE);
if (!Trans)
    {
    Code = 0;
    };
CString Id;
Id.Format (_T("%08li"), Code);
SetDlgItemText(IDC_ID, Id);
AfxGetApp()->WriteProfileString(_T("Change setup"), _T("Id"), Id);
CString Template;
Template.LoadString(IDS_CODE_TEMPLATE);
Template.Replace(_T("\n"), _T("\r\n"));
Template.Replace(_T("00006208"), _T("%08lu"));
CString Buffer;
Buffer.Format (Template, Code, Code);
SetDlgItemText (IDC_REPLACE_BY, Buffer);
CNavrcholuscriptchangerDlg *Changer = dynamic_cast <CNavrcholuscriptchangerDlg *> (GetParent()->GetParent());
if (!Changer)
    {
    return;
    };
Changer->m_ReplaceByStr = Buffer;
}

void CChangeSetupDlg::OnChangeFrom() 
{
CNavrcholuscriptchangerDlg *Changer = dynamic_cast <CNavrcholuscriptchangerDlg *> (GetParent()->GetParent());
if (!Changer)
    {
    return;
    };
GetDlgItemText(IDC_FROM, Changer->m_FromStr);
AfxGetApp()->WriteProfileString(_T("Change setup"), _T("From"), Changer->m_FromStr);
Changer->m_FromStr.MakeLower();
}

void CChangeSetupDlg::OnChangeTo() 
{
CNavrcholuscriptchangerDlg *Changer = dynamic_cast <CNavrcholuscriptchangerDlg *> (GetParent()->GetParent());
if (!Changer)
    {
    return;
    };
GetDlgItemText(IDC_TO, Changer->m_ToStr);
AfxGetApp()->WriteProfileString(_T("Change setup"), _T("To"), Changer->m_ToStr);
Changer->m_ToStr.MakeLower();
}

void CChangeSetupDlg::OnChangeReplaceBy() 
{
CNavrcholuscriptchangerDlg *Changer = dynamic_cast <CNavrcholuscriptchangerDlg *> (GetParent()->GetParent());
if (!Changer)
    {
    return;
    };
GetDlgItemText(IDC_REPLACE_BY, Changer->m_ReplaceByStr);
}
